﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPageExt.master" AutoEventWireup="true" CodeFile="reports_pi.aspx.cs" Inherits="reports_pi" %>
<%@ MasterType VirtualPath="~/MasterPageExt.master" %>
<%@ Register Assembly="Ext.Net" Namespace="Ext.Net" TagPrefix="ext" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cpHeader" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
<script type="text/javascript">
    var fnPIValForm = function () {
        if (App.dfFromDate.isValid() && App.dfToDate.isValid()) {
            App.btnOK.setDisabled(false);
        } else {
            App.btnOK.setDisabled(true);
        }
    };

</script>
    
    <ext:Window ID="wndLoadPIPop" 
    Title="Report Criteria" Hidden="true"
    Layout="AnchorLayout" Height="520" Width="480" 
    IDMode="Static" Padding="5" BodyPadding="5" runat="server"
    
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn">
    <Items> 

     <ext:Panel Border="false" ID="pnlReportDateRange" 
                Layout="ColumnLayout" runat="server">
     <Items>
        <ext:Label ID="lblpidrfrom" Text="Date Range:" Padding="2" runat="server" width="123"></ext:Label>
         
         <ext:DateField ID="dfFromDate"
             runat="server"
             AllowBlank="false"
             AutoDataBind="true"
             MaxDate="<%# DateTime.Today %>"
             SelectedDate="<%#DateTime.Today.AddDays(-90)%>"
             Width="100"
             Padding="5" 
             Format="MM/dd/yyyy"
             Vtype="date"
             InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
             <Listeners>
                 <Change Fn="fnPIValForm" />
             </Listeners>
        </ext:DateField>

        <ext:Label ID="lblpidrto" Text="To" runat="server" Padding="3"></ext:Label>
        <ext:DateField ID="dfToDate"
            runat="server"
            AllowBlank="false"
            MaxDate="<%# DateTime.Today %>"
            SelectedDate="<%# DateTime.Today %>"
            AutoDataBind="true"
            Width="100"
            Padding="5" 
            Format="MM/dd/yyyy"
            Vtype="date"
            InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
            <Listeners>
                 <Change Fn="fnPIValForm" />
             </Listeners>
        </ext:DateField>

    </Items>
    </ext:Panel>

       
        <ext:Panel Border="false" Layout="FormLayout" runat="server" width="458">
        <Items>
            
                     <ext:ComboBox
            ID="cboPISite1"
            runat="server"
            Editable="false"
            ValueField="SITE_ID"
            DisplayField="SITE_NAME"
            FieldLabel="Site 1"
            LabelWidth="120"
            Padding="2">
            <Store>
                <ext:Store ID="storPISite1" AutoLoad="true" runat="server">
                    <Model>
                        <ext:Model ID="mdlPISite1" runat="Server" IDProperty="SITE_ID">
                            <Fields>
                                <ext:ModelField Name="SITE_ID" />
                                <ext:ModelField Name="SITE_NAME" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:ComboBox>

         <ext:ComboBox
            ID="cboPISite2"
            runat="server"
            Editable="false"
            ValueField="SITE_ID"
            DisplayField="SITE_NAME"
            FieldLabel="Site 2"
            LabelWidth="120"
            Padding="2">
            <Store>
                <ext:Store ID="storPISite2" AutoLoad="true" runat="server">
                    <Model>
                        <ext:Model ID="Model5" runat="Server" IDProperty="SITE_ID">
                            <Fields>
                                <ext:ModelField Name="SITE_ID" />
                                <ext:ModelField Name="SITE_NAME" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:ComboBox>


            <ext:ComboBox
            ID="cboPICPAType"
            runat="server"
            Editable="false"
            ValueField="CPA_TYPE_ID"
            DisplayField="CPA_TYPE_TITLE"
            FieldLabel="Program"
            LabelWidth="120"
            Padding="2">
            <Store>
                <ext:Store ID="storPICPAType" AutoLoad="true" runat="server">
                    <Model>
                        <ext:Model ID="Model4" runat="Server" IDProperty="CPA_TYPE_ID">
                            <Fields>
                                <ext:ModelField Name="CPA_TYPE_ID" />
                                <ext:ModelField Name="CPA_TYPE_TITLE" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:ComboBox>


             <ext:ComboBox ID="cboReportClinicalSetting" runat="server" 
                 Editable="false" 
                 FieldLabel="Clinical Setting" Padding="2" LabelWidth="120">
                <Items>
                    <ext:ListItem Text="All" Value="-1" Mode="Raw" />
                    <ext:ListItem Text="Inpatient" Value="2" Mode="Raw" />
                    <ext:ListItem Text="Outpatient" Value="1" Mode="Raw" />
                </Items>
            </ext:ComboBox>

             <ext:ComboBox
            ID="cboReportImpairment"
            runat="server"
            Editable="false"
            ValueField="RID"
            DisplayField="RESPONSE"
             
            FieldLabel="Primary Impairment"
            LabelWidth="120"
            Padding="2">
            <Store>
                <ext:Store ID="storImpairment" AutoLoad="true" runat="server">
                    <Model>
                        <ext:Model runat="Server" IDProperty="RID">
                            <Fields>
                                <ext:ModelField Name="RID" />
                                <ext:ModelField Name="RESPONSE" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:ComboBox>

        <ext:ComboBox
            ID="cboReportInjury"
            runat="server"
            Editable="false"
            ValueField="RID"
            DisplayField="RESPONSE"
             
            FieldLabel="Mechanism of Injury"
            LabelWidth="120"
            Padding="2">
            <Store>
                <ext:Store ID="storInjury" AutoLoad="true" runat="server">
                    <Model>
                        <ext:Model  runat="Server" IDProperty="RID">
                            <Fields>
                                <ext:ModelField Name="RID" />
                                <ext:ModelField Name="RESPONSE" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:ComboBox>

         
             <ext:ComboBox ID="cboReportGender" runat="server" 
                 Editable="false" Width="450"
                 FieldLabel="Gender" Padding="2" LabelWidth="120">
                <Items>
                    <ext:ListItem Text="All" Value="-1" Mode="Raw" />
                    <ext:ListItem Text="Male" Value="1" Mode="Raw" />
                    <ext:ListItem Text="Female" Value="2" Mode="Raw" />
                </Items>
            </ext:ComboBox>

        <ext:ComboBox
            ID="cboReportMilStatus"
            runat="server"
            Editable="false"
            ValueField="COLLECTION_ITEM_ID"
            DisplayField="ITEM"
             
            FieldLabel="Duty Status"
            LabelWidth="120"
            Padding="2">
            <Store>
                <ext:Store ID="storMilStatus" AutoLoad="true" runat="server">
                    <Model>
                        <ext:Model runat="Server" IDProperty="COLLECTION_ITEM_ID">
                            <Fields>
                                <ext:ModelField Name="COLLECTION_ITEM_ID" />
                                <ext:ModelField Name="ITEM" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:ComboBox>

        

        </Items>
        </ext:Panel>

             <ext:GridPanel
            ID="gpInstruments"
            runat="server"
            Border="false"
            Layout="FitLayout"
            Padding="2"
            Title="Instruments"
            width="458"
            Height="198" AutoScroll="true">
            <SelectionModel>
                <ext:CheckboxSelectionModel ID="smaInstruments"
                    runat="server"
                    Mode="Simple">
                </ext:CheckboxSelectionModel>
            </SelectionModel>
            <ColumnModel ID="ColumnModel4" runat="server">
                <Columns>
                    <ext:Column ID="Column33" runat="server"
                        DataIndex="MODULE"
                        Text="Instrument Name"
                        Flex="1">
                        <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                    </ext:Column>
                 </Columns>
            </ColumnModel>
            <Store>
                <ext:Store
                    ID="storInstruments"
                    AutoLoad="true"
                    runat="server">
                    <Model>
                        <ext:Model ID="mdaInstruments"
                            runat="Server"
                            IDProperty="MID">
                            <Fields>
                                <ext:ModelField Name="MID" />
                                <ext:ModelField Name="MODULE">
                                </ext:ModelField>
                                <ext:ModelField Name="MODULE_FOR" />
                                <ext:ModelField Name="DESCRIPTION">
                                </ext:ModelField>
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:GridPanel>

    </Items>
<BottomBar>
        <ext:Toolbar runat="server">
        <Items>
            <ext:Button ID="btnOK" runat="server" Text="Run Report" Icon="Disk" Handler="App.direct.REPSPI.RunReport(Ext.util.Format.htmlEncode(Ext.encode(#{gpInstruments}.getRowsValues({selectedOnly : true}))));" >
               <Listeners>
               </Listeners>
            </ext:Button>
            <ext:Button ID="btnCancel" runat="server" Text="Cancel" Icon="Cancel" Handler="App.wndLoadPIPop.hide();" >
                <Listeners>
               </Listeners>
            </ext:Button>
        </Items>
        </ext:Toolbar>
        </BottomBar>
        
    </ext:Window>

<ext:Panel 
    ID="pnlbodyPI" 
    Padding="5" 
    BodyPadding="5" 
    runat="server"
    
    AutoScroll="false"
    Layout="VBoxLayout"
    AnchorHorizontal="100%"
    AnchorVertical="100%"
    Border="false"
    Frame="false"
>
<LayoutConfig>
    <ext:VBoxLayoutConfig Align="Stretch" />
</LayoutConfig>
<Items>

    <ext:Panel runat="server" Height="30" Border="false" Frame="false">
    <Items>
    <ext:Button Padding="3" ID="btnPILoadPop" runat="server" Text="Load and Run Report" Height="25">
    <Listeners>
        <Click Handler="App.wndLoadPIPop.show();"></Click>
    </Listeners>    
    </ext:Button>
    <ext:Label runat="server" Text=" "></ext:Label>
    <ext:Button Padding="3" ID="btnPIExport" 
        runat="server" Text="To CSV" Height="25" 
        AutoPostBack="true" OnClick="ToCsv" Icon="PageAttach">
        <Listeners>
        </Listeners>
    </ext:Button>
    </Items>
    </ext:Panel>
         
    <ext:TreePanel
            ID="tpnlSite1"
            runat="server"
            Title="Site 1"
            Padding="0"
            Border="true"
            Collapsible="false"
            UseArrows="true"
            RootVisible="false"
            MultiSelect="true"
            SingleExpand="false"
            SortableColumns="false"
            FolderSort="false"
            IDMode="Static"
            Lines="true"
            ColumnLines="true"
            RowLines="true" 
            AutoScroll="false"
            Flex="2"
            
            Layout="FitLayout"
            
            >

            <Fields>
                <ext:ModelField Name="site_id" />
                <ext:ModelField Name="mid" />
                <ext:ModelField Name="series" />
                <ext:ModelField Name="admission_average" />
                <ext:ModelField Name="discharge_average" />
                <ext:ModelField Name="average_change" />
                <ext:ModelField Name="followup_average" />
                <ext:ModelField Name="average_los" />
                <ext:ModelField Name="score_description" />
            </Fields>
            <ColumnModel>
                <Columns>
                   
                    <ext:TreeColumn ID="colPI_module"
                        runat="server"
                        Text="Score Name"
                        width="330"
                        Sortable="false"
                        DataIndex="score_description" />

                            <ext:Column ID="colPI_admission_average"
                                runat="server"
                                Text="Admission Avg"
                                Flex="1"
                                Sortable="true"
                                DataIndex="admission_average" />

                            <ext:Column ID="colPI_discharge_average"
                                runat="server"
                                Text="Discharge Avg"
                                Flex="1"
                                Sortable="true"
                                DataIndex="discharge_average" />

                             <ext:Column ID="colPI_average_change"
                                runat="server"
                                Text="Avg Change"
                                Flex="1"
                                Sortable="true"
                                DataIndex="average_change" />

                             <ext:Column ID="colPI_followup_average"
                                runat="server"
                                Text="Follow Up"
                                Flex="1"
                                Sortable="true"
                                DataIndex="followup_average" />

                            <ext:Column ID="colPI_average_los"
                                runat="server"
                                Text="Average LOS"
                                Flex="1"
                                Sortable="true"
                                DataIndex="average_los" />
                
                </Columns>

            </ColumnModel>
            <Listeners>
            </Listeners>
            <SelectionModel>
                <ext:TreeSelectionModel ID="tsmPI1" EnableKeyNav="true" runat="server" Mode="Single">
                    <Listeners>
                    </Listeners>
                    <CustomConfig>
                    </CustomConfig>
                </ext:TreeSelectionModel>
            </SelectionModel>
    </ext:TreePanel>
   
    <ext:TreePanel
            ID="tpnlSite2"
            runat="server"
            Title="Site 2"
            Padding="0"
            Border="true"
            Collapsible="false"
            UseArrows="true"
            RootVisible="false"
            MultiSelect="true"
            SingleExpand="false"
            SortableColumns="false"
            FolderSort="false"
            IDMode="Static"
            Lines ="true"
            ColumnLines="true"
            RowLines="true" 
            AutoScroll="false"
            Flex="2"
            
            Layout="FitLayout"

            >
            <Fields>
                <ext:ModelField Name="site_id" />
                <ext:ModelField Name="mid" />
                <ext:ModelField Name="series" />
                <ext:ModelField Name="admission_average" />
                <ext:ModelField Name="discharge_average" />
                <ext:ModelField Name="average_change" />
                <ext:ModelField Name="followup_average" />
                <ext:ModelField Name="average_los" />
                <ext:ModelField Name="score_description" />
            </Fields>
            <ColumnModel>
                <Columns>
                   
                    <ext:TreeColumn ID="TreeColumn1"
                        runat="server"
                        Text="Score Name"
                        Width="330"
                        Sortable="false"
                        DataIndex="score_description" />

                            <ext:Column ID="Column28"
                                runat="server"
                                Text="Admission Avg"
                                Flex="1"
                                Sortable="true"
                                DataIndex="admission_average" />

                            <ext:Column ID="Column29"
                                runat="server"
                                Text="Discharge Avg"
                                Flex="1"
                                Sortable="true"
                                DataIndex="discharge_average" />

                             <ext:Column ID="Column30"
                                runat="server"
                                Text="Avg Change"
                                Flex="1"
                                Sortable="true"
                                DataIndex="average_change" />

                             <ext:Column ID="Column31"
                                runat="server"
                                Text="Follow Up"
                                Flex="1"
                                Sortable="true"
                                DataIndex="followup_average" />

                            <ext:Column ID="Column32"
                                runat="server"
                                Text="Average LOS"
                                Flex="1"
                                Sortable="true"
                                DataIndex="average_los" />
                
                </Columns>

            </ColumnModel>
            <Listeners>
            </Listeners>
            <SelectionModel>
                <ext:TreeSelectionModel ID="TreeSelectionModel1" EnableKeyNav="true" runat="server" Mode="Single">
                    <Listeners>
                    </Listeners>
                    <CustomConfig>
                    </CustomConfig>
                </ext:TreeSelectionModel>
            </SelectionModel>
     </ext:TreePanel>
  
      
</Items>
</ext:Panel>                   
 
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="cpScripts" Runat="Server">
</asp:Content>

